package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserCollectBiz;
import com.github.wxiaoqi.security.admin.dto.AppUserCollectDTO;
import com.github.wxiaoqi.security.admin.entity.AppUser;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @author keliii
 */
@RestController
@RequestMapping("app/user")
@Slf4j
public class AppUserCollectController extends CommonBaseController {


    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    AppUserCollectBiz collectBiz;



    /**
     * 我的收藏
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/collect/page")
    @ApiModelProperty("我的收藏")
    public ObjectRestResponse list(
            @RequestParam(value = "page",defaultValue = "1")Integer page,
            @RequestParam(value = "limit",defaultValue = "10")Integer limit,
            @RequestParam(value = "type",defaultValue = "0")Integer type
    ) {
        try {
            String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId();
            if (username == null) {
                throw new Exception();
            }
            Integer userid=Integer.parseInt(username);
            return collectBiz.getCollectList(userid,type,page,limit);
        }catch (Exception e) {
            log.error(e.getMessage());
            return ObjectRestResponse.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
    }

    @RequestMapping(value = "/collect/add",method = RequestMethod.POST)
    @ApiModelProperty("添加收藏")
    public ObjectRestResponse add(@RequestBody AppUserCollectDTO collectDTO)throws Exception{
        String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId();
        if (username == null) {
            throw new Exception();
        }
        Integer userid=Integer.parseInt(username);
        collectDTO.setUserId(userid);
        return collectBiz.addUserCollect(collectDTO);
    }

    @RequestMapping(value = "/collect",method = RequestMethod.GET)
    @ApiModelProperty("查看是否收藏")
    public ObjectRestResponse<AppUser> get(
            @RequestParam(value = "id",defaultValue = "")String id,
            @RequestParam(value = "type",defaultValue = "0")Integer type
            )throws Exception{
        String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId();
        if (username == null) {
            throw new Exception();
        }
        Integer userid=Integer.parseInt(username);
        return collectBiz.checkUserCollect(id,userid,type);
    }
    /**
     * 取消收藏
     * @param collectDTO
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/collect/remove",method = RequestMethod.POST)
    @ApiModelProperty("取消收藏")
    public ObjectRestResponse remove(@RequestBody AppUserCollectDTO collectDTO)throws Exception {
        collectDTO.setUserId(getCurrentUserIdInt());
        return collectBiz.upUserCollect(collectDTO);

    }

    @GetMapping("/collect/exist")
    @ApiOperation("判断是否收藏")
  public boolean isCollectionByTypeAndTypeId(@RequestParam("userId") Integer userId,
                                             @RequestParam(value = "type") int type,
                                             @RequestParam("id") String typId){
       return collectBiz.isCollectionByTypeAndTypeId(userId,type,typId);
    }
}
