/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.taobao.csp.sentinel.dashboard.discovery.AppManagement;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.view.Result;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/registry"}, produces={"application/json"})
public class MachineRegistryController {
    Logger logger = LoggerFactory.getLogger(MachineRegistryController.class);
    @Autowired
    private AppManagement appManagement;

    @ResponseBody
    @RequestMapping(value={"/machine"})
    public Result<?> receiveHeartBeat(String app, Long version, String hostname, String ip, Integer port) {
        if (app == null) {
            app = "UNKNOWN";
        }
        if (ip == null) {
            return Result.ofFail((int)-1, (String)"ip can't be null");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (port == -1) {
            this.logger.info("receive heartbeat from " + ip + " but port not set yet");
            return Result.ofFail((int)-1, (String)"your port not set yet");
        }
        if (version == null) {
            version = System.currentTimeMillis();
        }
        try {
            MachineInfo machineInfo = new MachineInfo();
            machineInfo.setApp(app);
            machineInfo.setHostname(hostname);
            machineInfo.setIp(ip);
            machineInfo.setPort(port);
            machineInfo.setVersion(new Date(version));
            this.appManagement.addMachine(machineInfo);
            return Result.ofSuccessMsg((String)"success");
        }
        catch (Exception e) {
            this.logger.error("receive heartbeat error:", (Throwable)e);
            return Result.ofFail((int)-1, (String)e.getMessage());
        }
    }
}

