package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.tour.biz.TourUserBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.entity.TourUser;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("tourUser")
public class TourUserController extends TourBaseController<TourUserBiz> {

    @Autowired
    private TourUserBiz tourUserBiz;


    /**
     * 获取全部成人或儿童
     * @param isChild 0-儿童 1-成年人
     * @return
     */
    @GetMapping("/app/unauth/getTourUser/{isChild}")
    public ObjectRestResponse findListByTourUserByIsChild(@PathVariable int isChild){
        AppUserDTO userInfo = getUserInfo();
        Integer id = userInfo.getId();
        List<TourUser> tourUsers= baseBiz.findListByTourUserByIsChild(id,isChild);

       return ObjectRestResponse.succ(tourUsers);
    }


    @GetMapping("/app/unauth/getTourUsers")
    public ObjectRestResponse<List<TourUser>> getTourUsers(@ApiParam(name = "ids") String ids){
        List<TourUser> tourUsers= tourUserBiz.selectByExample(new Example.Builder(TourUser.class)
                .where(WeekendSqls.<TourUser>custom()
                .andIn(TourUser::getId, Arrays.asList(ids.split(",")))
                ).build());
        return ObjectRestResponse.succ(tourUsers);
    }


    @ApiOperation("修改")
    @PostMapping(value = "/update")
    public ObjectRestResponse<TourUser> update(@RequestBody TourUser tourUser){
        baseBiz.updateSelectiveById(tourUser);
        return new ObjectRestResponse<TourUser>();
    }

    @ApiOperation("添加")
    @PostMapping(value = "/add")
    public ObjectRestResponse<TourUser> add(@RequestBody TourUser tourUser){
        baseBiz.insertSelective(tourUser);
        return new ObjectRestResponse<TourUser>();
    }


    /**
     * 获取全部出游人信息
     * @return
     */
    @GetMapping("/app/unauth/getTourUserList")
    public ObjectRestResponse getTourUser(){
        AppUserDTO userInfo = getUserInfo();
        Integer id = userInfo.getId();
        List<TourUser> tourUsers= baseBiz.getTourUser(id);
        return ObjectRestResponse.succ(tourUsers);
    }


}