package com.xxfc.platform.tour.mapper;

import com.xxfc.platform.tour.dto.TourTagBannerDTO;
import com.xxfc.platform.tour.entity.TourTagBanner;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 标签轮播图
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
public interface TourTagBannerMapper extends Mapper<TourTagBanner> {

    /**
     * 根据是否删除状态来查询数据
     * @param isDel
     */
    @Select("select * from tour_tag_banner where `is_del`=#{isDel}")
    List<TourTagBanner> findAllByState(@Param("isDel") int isDel);

    /**
     * 根据主键id更新banner状态
     * @param id
     * @param status
     * @return
     */
    @Update("update tour_tag_banner set `is_del`=#{status} where `id`=#{id}")
    int updateTourTagBannerStatusById(@Param("id") int id, @Param("status") int status);

    /**
     * 根据标签id查询
     * @param tagId
     * @return
     */
    @Select("select * from tour_tag_banner where `tag_id`=#{tagId} and `is_del`=#{status}")
    List<TourTagBanner> findByTagId(@Param("tagId") Integer tagId,@Param("status") Integer status);

    /**
     * 根据标签id更新banner状态
     * @param tagId
     * @param status
     * @return
     */
    @Update("update tour_tag_banner set `is_del`=#{status},`upd_time`=#{updTime} where `tag_id`=#{tagId}")
    int updateTourTagBannerStatusByTagId(@Param("tagId") Integer tagId, @Param("status") int status,@Param("updTime") Long updTime);

    /**
     * 更改banner信息
     * @param tourTagBannerDTO
     * @return
     */
    @Update("update tour_tag_banner set `title`=#{title},`cover`=#{cover},`upd_time`=#{updTime},`upd_name`=#{updName},`url`=#{url} where `id`=#{id}")
    int updateTourTagBanner(TourTagBannerDTO tourTagBannerDTO);


    /**
     * 根据标签id 设置除了tourTagBannerIds集合中的id 的tagbanner状态
     * @param tourTagBannerIds
     * @param tagId
     * @param status
     */
    void updateTourBannerStatusByTagannerIdsAndTagId(@Param("tourTagBannerIds") List<Long> tourTagBannerIds, @Param("tagId") Integer tagId,@Param("status") Integer status);
}
