package com.xxfc.platform.tour.feign;


import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.TourUser;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-tour")
public interface TourFeign {

    /**
     * 计算价格
     * @param spePriceDto
     * @return
     */
    @RequestMapping(value = "/spe/user/prices", method = RequestMethod.POST)
    public ObjectRestResponse<TourSpePriceVo> refund(@RequestBody TourSpePriceDTO spePriceDto);

    @RequestMapping(value = "/spe/stock", method = RequestMethod.GET)
    public ObjectRestResponse<TourSpePriceVo> stock(@RequestParam Integer speId, @RequestParam Integer number);


    @RequestMapping(value = "/tourGood/app/unauth/usable/{id}", method = RequestMethod.GET)
    public ObjectRestResponse<TourGood> usableGet(@PathVariable int id);

    @GetMapping("/tourUser/app/unauth/getTourUsers")
    public ObjectRestResponse<List<TourUser>> getTourUsers(@RequestParam  String ids);

}
