package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import javax.persistence.*;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游线路核销明细
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-14 09:36:50
 */
@Data
@Table(name = "tour_good_verification")
@ApiModel("旅游线路核销明细")
public class TourGoodVerification implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 日期规格
     */
    @Column(name = "spe_id")
    @ApiModelProperty(value = "日期规格id")
    private Integer speId;

    /**
     * 旅游路线id
     */
    @Column(name = "good_id")
    @ApiModelProperty(value = "旅游路线id")
    private Integer goodId;

    /**
     * 出发路线id
     */
    @Column(name = "site_id")
    @ApiModelProperty(value = "出发路线id")
    private Integer siteId;

    
    /**
     * 总人数
     */
    @Column(name = "total_person")
    @ApiModelProperty(value = "总人数")
    private Integer totalPerson;

    /**
     * 核销人数
     */
    @Column(name = "verification_person")
    @ApiModelProperty(value = "核销人数")
    private Integer verificationPerson;

    /**
     * 状态：0-未发车；1-已发车
     */
    @Column(name = "status")
    @ApiModelProperty(value = "状态：0-未发车；1-已发车")
    private Integer status;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;

}
