package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
@Service
public class BaseOrderBiz extends BaseBiz<BaseOrderMapper,BaseOrder> {
    public List<OrderPageVO> pageByParm(Map<String, Object> paramMap){
        return mapper.pageByParm(paramMap);
    }
    private static Map<Integer, List<Integer>> cancelAble;
    static {
        cancelAble = new HashMap<Integer, List<Integer>>();
        cancelAble.put(OrderTypeEnum.RentVehicle.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
        }});
        cancelAble.put(OrderTypeEnum.TOUR.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
        }});
    }

    public void cancel(BaseOrder baseOrder) {
        if(cancelAble.get(baseOrder.getType()).contains(baseOrder.getStatus())) {
            this.updateSelectiveById(new BaseOrder(){{
                setId(baseOrder.getId());
                setStatus(OrderStatusEnum.ORDER_CANCEL.getCode());
                setCancelReason(baseOrder.getCancelReason());
            }});
        }else {
            throw new BaseException(ResultCode.FAILED_CODE);
        }
    }
}