package com.xxfc.platform.summit.controller;

import cn.hutool.core.codec.Base64;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.biz.UserBiz;
import com.xxfc.platform.summit.constant.RedisKey;
import com.xxfc.platform.summit.service.WXjsService;
import com.xxfc.platform.summit.service.WeixinService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

/**
 * @author Administrator
 */
@Controller
@RequestMapping("/auth")
@Slf4j
public class WeixinController {

    public static final String WECHAT_AUTOLOGIN_CALLBACKURL_KEY = "callback";

    @Autowired
    WeixinService weixinService;

    @Autowired
    UserBiz userBiz;

    @Autowired
    ActivityBmBiz activityBmBiz;

    @Autowired
    WXjsService wXjsService;
    

    @Value("${wx.url}")
    private String  url;




    @RequestMapping(value ="/app/unauth/wxLogin",method = RequestMethod.GET)
    @IgnoreUserToken
    public String wxLogin(@RequestParam(value = "callback",defaultValue = "")String redirec_url,HttpServletRequest request){
        if (StringUtils.isBlank(redirec_url)){
            redirec_url="";
        }

        redirec_url=request.getServerName()+"/"+redirec_url;
        log.info("-----微信wxLogin---redirec_url=="+redirec_url);
        try {
        String encrypt_curr_url = Base64.encode(redirec_url.getBytes("utf-8"));
        redirec_url=url+"?" + WECHAT_AUTOLOGIN_CALLBACKURL_KEY+ "=" + encrypt_curr_url;
        String  oauth_api=redirec_url+"&code=111";//weixinService.getAuthorize(redirec_url);
         log.info("-----微信wxLogin---oauth_api=="+redirec_url);
         return  String.format("redirect:"+oauth_api);
        }catch (Exception e){
            e.printStackTrace();
            log.info("网络异常===" + e.getMessage());
            return  String.format("网络异常");
        }
    }

    /**
     * 微信浏览器获取用户信息
     * @param code
     * @param callback
     * @return
     */
    @GetMapping(value = "/app/unauth/userInfo")
    public String getUserInformation(String code, String callback, HttpServletRequest request) {
        log.info("-----微信回调userInfo---code=="+code+"----redirec_url==="+callback);
        try {
            callback =new String(Base64.decode(callback), "utf-8");
            log.info("-----微信回调----callback==="+callback);
            String [] params=callback.split(",");
            String key=null;
            if (params.length>1){
                callback=params[0];
                key= RedisKey.CONSTANT_CODE_PREFIX+params[1];
            }
             params=callback.split("_");
            Integer activityId=0;
            String auto=null;
            if (params.length>1){
                callback=params[0];
                activityId=Integer.parseInt(params[1]);
                auto="1";
            }
            log.info("-----微信回调userInfo---key=="+key+"----activityId==="+activityId+"----callback==="+callback);
            userBiz.authUser(code,key,activityId,request);
            if (StringUtils.isNotBlank(key)){
                callback+="&key="+key;
            }
            if (StringUtils.isNotBlank(auto)&&callback.contains("summitDetail.html")){
                callback+="&a=1";
            }
            log.info("callback===" + callback);
            return  String.format("redirect:"+callback);
        }catch (Exception e){
            e.printStackTrace();
            log.info("网络异常===" + e.getMessage());
            return  String.format("网络异常");
        }

    }


    /**
     * 微信分享
     * @param url
     * @return
     */
    @GetMapping(value = "/app/unauth/share")
    public @ResponseBody  ObjectRestResponse share(@RequestParam("url") String url) {
        log.info("-----微信分享share---url=="+url);
        try {
            return ObjectRestResponse.succ(wXjsService.getShareData(url));
        }catch (Exception e){
            e.printStackTrace();
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"网络异常");
        }

    }




}
