package com.xxfc.platform.universal.biz;

import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Slf4j
@Service
public class MailServiceBiz {

	@Autowired
	 JavaMailSender mailSender;

	public void sendSimpleMail(String to, String subject, String content) {
		SimpleMailMessage message = new SimpleMailMessage();
		message.setFrom(SystemConfig.EMAILADDRESS);
		message.setTo(to);
		message.setSubject(subject);
		message.setText(content);

		try {
			mailSender.send(message);
			log.info("简单邮件已经发送。{}", message);
		}catch (Exception e) {
			log.error("发送简单邮件时发生异常！", e);
		}

	}

	public void run(String to, String subject, String content) {
		ExecutorService executorService = Executors.newCachedThreadPool();
		executorService.submit(new Task(to, subject, content));
	}

	@Data
	class Task implements Runnable{
		private String toUser;
		private String subject;
		private String content;

		public Task(String toUser, String subject, String content) {
			this.toUser = toUser;
			this.subject = subject;
			this.content = content;
		}

		@Override
		public void run() {
			sendSimpleMail(toUser, subject, content);
		}
	}
}