package com.xxfc.platform.order.biz;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.mapper.OrderRentVehicleDetailMapper;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 租车订单详情
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-16 14:36:45
 */
@Slf4j
@Service
public class OrderRentVehicleBiz extends BaseBiz<OrderRentVehicleDetailMapper, OrderRentVehicleDetail> {

    @Autowired
    BaseOrderBiz baseOrderBiz;
    @Autowired
    VehicleFeign vehicleFeign;


    public List<OrderRentVehicleDetail> listByOrderId(Integer orderId) {
        return mapper.listByOrderId(orderId);
    }
    //评分
    public JSONObject addScore(Integer userid,Integer score,Integer orderId) {
      try {
          List<OrderRentVehicleDetail> list=mapper.listByOrderId(orderId);
          int num=0;
          if(list.size()>0){
              Example example = new Example(OrderRentVehicleDetail.class);
              Example.Criteria criteria = example.createCriteria();
              criteria.andEqualTo("order_id",orderId);
              OrderRentVehicleDetail detail=list.get(0);
              Integer modelId=detail.getModelId();
              detail=new OrderRentVehicleDetail();
              detail.setScore(score);
              detail.setSUserid(userid);
              detail.setSTime(System.currentTimeMillis());
              num=mapper.updateByExampleSelective(detail,example);
              if(num>0){
                  score=mapper.getPScore(modelId);
                  vehicleFeign.addScore(modelId,score);
                  return JsonResultUtil.createSuccessResultWithObj(orderId);

              }
          }
          return JsonResultUtil.createDefaultFail();
      }catch (Exception e){
          log.error(e.getMessage(), e);
          return JsonResultUtil.createDefaultFail();
      }

    }
    //获取用户评分列表
    public JSONObject getScoreAll(Integer orderId) {
        try {
            Example example = new Example(OrderRentVehicleDetail.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("order_id",orderId);
           List<OrderRentVehicleDetail> list=mapper.selectByExample(example);
           if(list.size()>0){
               OrderRentVehicleDetail detail=list.get(0);
               Integer modelId=detail.getModelId();

           }


            return JsonResultUtil.createDefaultFail();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return JsonResultUtil.createDefaultFail();
        }
    }

    //获取全部评论


}