package com.github.wxiaoqi.security.admin.entity;

import lombok.Data;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 用户关系表
 * 
 * @author Mr.AG
 * @email 463540703@qq.com
 * @date 2019-06-04 14:29:29
 */
@Data
@Table(name = "base_user_relation")
public class BaseUserRelation implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键id
    @Id
    private Integer id;
	
	    //用户id
    @Column(name = "user_id")
    private Integer userId;
	
	    //小程序用户id
    @Column(name = "to_uid")
    private Integer toUid;
	
	    //是否有效；0-有效；1-无效
    @Column(name = "staus")
    private Integer staus;
	
	    //创建时间
    @Column(name = "crt_time")
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
    private Long updTime;
	
	    //是否删除；0-正常；1-删除
    @Column(name = "is_del")
    private Integer isDel;

}
