package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 车型
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 14:50:08
 */
@Data
@Table(name = "vehicle_model")
public class VehicleModel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    //名称
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    //房车配置，code逗号分割
    @Column(name = "config")
	@ApiModelProperty(value = "房车配置，code逗号分割")
    private String config;

	@Column(name = "number")
	@ApiModelProperty(value = "乘卧数")
	private String number;

	@Column(name = "brand")
	@ApiModelProperty(value = "品牌")
	private String brand;

	    //关键标签，code逗号分割
    @Column(name = "keyword")
	@ApiModelProperty(value = "关键标签，code逗号分割")
    private String keyword;

		//车型详情
	@Column(name = "models_details")
	@ApiModelProperty(value = "车型详情")
	private String modelsDetails;

		//参数
	@Column(name = "model_param")
	@ApiModelProperty(value = "参数")
	private String modelParam;
	
	    //图片地址 多张为逗号分割
    @Column(name = "picture")
	@ApiModelProperty(value = "图片地址 多张为逗号分割")
    private String picture;

	//价格
	@Column(name = "price")
	@ApiModelProperty(value = "价格")
	private BigDecimal price;

	
	//总押金
	@Column(name = "deposit")
	@ApiModelProperty(value = "总押金")
	private BigDecimal deposit;

	//违章押金
	@Column(name = "vio_deposit")
	@ApiModelProperty(value = "违章押金")
	private BigDecimal vioDeposit;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    //创建者id
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private Integer crtUser;
	
	    //创建者名称
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;
	
	    //创建者host
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者host")
    private String crtHost;
	
	    //修改时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    //修改者
    @Column(name = "upd_user")
	@ApiModelProperty(value = "修改者")
    private Integer updUser;
	
	    //修改者名称
    @Column(name = "upd_name")
	@ApiModelProperty(value = "修改者名称")
    private String updName;
	
	    //修改者host
    @Column(name = "upd_host")
	@ApiModelProperty(value = "修改者host")
    private String updHost;

	//评分
	@Column(name = "score")
	@ApiModelProperty(value = "评分")
	private Integer score;

	@Column(name = "hot_sign")
	@ApiModelProperty(value = "热度标记，1--热门；2--非热门")
	private Integer hotSign;

	@ApiModelProperty(value = "是否删除")
	@Column(name = "isdel")
	private  Integer isdel;
	@Column(name = "rent_discount_status")
	@ApiModelProperty(value = "租车优惠状态 0--没有优惠;1--会员折扣;2--固定值")
	private Integer rentDiscountStatus;

	@Column(name = "rent_discount_price")
	@ApiModelProperty(value = "租车优惠价格")
	private String rentDiscountPrice;

	@Column(name = "buy_price")
	@ApiModelProperty(value = "购买价格")
	private  BigDecimal buyPrice;

	@Column(name = "status")
	@ApiModelProperty(value = "状态 0--下架；1--上架")
	private  Integer status;

	@Column(name = "cover_pic")
	@ApiModelProperty(value = "封面图")
	private  String coverPic;

	@Column(name = "poster_background")
	@ApiModelProperty(value = "海报背景")
	private String posterBackground;

	@Column(name = "sort")
	@ApiModelProperty(value = "排序")
	private Integer sort;

	@Column(name = "intro")
	@ApiModelProperty(value = "简介")
	private String intro;

	@ApiModelProperty("seo*html标签优化")
	private String alt;

	@Column(name = "img_title")
	@ApiModelProperty("seo*html标签优化")
	private String imgTitle;

	@Column(name = "img_keyword")
	@ApiModelProperty("seo*html标签优化")
	private String imgKeyword;

	@Column(name = "img_desc")
	@ApiModelProperty("seo*html标签优化")
	private String imgDesc;

	@Column(name = "app_show")
	@ApiModelProperty("是否在App展示")
	private Integer appShow;
}
