package com.xxfc.platform.universal.controller;


import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.biz.AliYunSmsBiz;
import com.xxfc.platform.universal.biz.CCPRestSmsBiz;
import com.xxfc.platform.universal.dto.SmsTemplateDTO;
import com.xxfc.platform.universal.service.SmsService;
import com.xxfc.platform.universal.service.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.UUID;


/**
 * Servlet implementation class FileDemo
 */
@RestController
@RequestMapping("sms")
@IgnoreUserToken
public class SmsController {

       @Autowired
       SmsService smsService;

       @Autowired
       CCPRestSmsBiz smsBiz;

       @Autowired
       AliYunSmsBiz aliYunSmsBiz;

    @RequestMapping(value = "/app/unauth/send", method = RequestMethod.GET) //匹配的是href中的download请求
    public JSONObject sendSms(@RequestParam("phone") String phone) throws Exception {
        return smsService.smsCode(phone);
    }
    @RequestMapping(value = "/app/unauth/sendCode", method = RequestMethod.GET)
    public JSONObject sendCode(
            @RequestParam("phone") String phone,
            @RequestParam("code")String code,
            @RequestParam("templateCode")String templateCode ) throws Exception {
        return smsService.smsByCode(phone,code,templateCode);
    }

    @RequestMapping(value = "/app/unauth/sendTemplate", method = RequestMethod.POST)
    public ObjectRestResponse sendTemplate(@RequestBody SmsTemplateDTO smsTemplateDTO) throws Exception {
        if(smsTemplateDTO==null){
             return  ObjectRestResponse.createDefaultFail();
        }
        Integer type=smsTemplateDTO.getType();
        String[] params=smsTemplateDTO.getParams();
        String phoneNumbers=smsTemplateDTO.getPhoneNumbers();
        aliYunSmsBiz.sendTemplateSMS(type,phoneNumbers,params);
        return ObjectRestResponse.succ();
    }
}

