package com.xxfc.platform.universal.entity;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@Data
@Builder(toBuilder = true)
public class SysRegion {

    @Tolerate
    public SysRegion() {
    }

    private Long id;

    /**
     * 所属父地区id
     */
    private Long parentId;


    private String name;

    /**
     * 地区类型 0-国家 1-省/直辖市 2-市 3 - 镇、县
     */
    private Integer type;

    /**
     * 从左往右，第1,2位代表省代码，3、4为代表市代码，5-6位代表镇或县代码
     */
    private Integer agencyId;

}
