package com.xxfc.platform.uccn;

import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import tk.mybatis.spring.annotation.MapperScan;

/**
 *
 * @author Administrator
 */
@SpringBootApplication(scanBasePackages ={
        "com.github.wxiaoqi.security.common.handler",
        "com.xxfc.platform"
})
@EnableDiscoveryClient
@EnableAceAuthClient
@EnableFeignClients(value = {"com.xxfc.platform","com.github.wxiaoqi.security"}, defaultConfiguration = HeaderConfig.class)
@MapperScan(basePackages = "com.xxfc.platform.uccn.mapper")
public class UccnApplication {
    public static void main(String[] args) {
        SpringApplication.run(UccnApplication.class,args);
    }
}
