/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.client.protocol;

import java.io.IOException;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.auth.AuthState;
import ytx.org.apache.http.client.protocol.RequestAuthenticationBase;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestTargetAuthentication
extends RequestAuthenticationBase {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (request.containsHeader("Authorization")) {
            return;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState == null) {
            this.log.debug("Target auth state not set in the context");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Target auth state: " + (Object)((Object)authState.getState()));
        }
        this.process(authState, request, context);
    }
}

