package com.xxfc.platform.vehicle.rest.admin;


import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.VehicleApplyBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleApply;
import com.xxfc.platform.vehicle.pojo.dto.VehicleApplyFindDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/vehicle")
@Api(tags = {"商品申请"})
public class AdminVehicleApplyController extends BaseController<VehicleApplyBiz, VehicleApply>implements UserRestInterface {





    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @GetMapping("apply/selectList")
    @ApiModelProperty("列表")
    public  ObjectRestResponse applySelectList(VehicleApplyFindDTO vehicleApplyFindDTO) {
     return  baseBiz.selectList(vehicleApplyFindDTO);
    }


    @GetMapping("apply/info/{id}")
    @ApiModelProperty("信息")
    public  ObjectRestResponse applyInfo(@PathVariable("id") Long id ) {
        return ObjectRestResponse.succ( baseBiz.getApplyInfo(id));
    }


    @GetMapping("info/{id}")
    @ApiModelProperty("商家信息")
    public  ObjectRestResponse info(@PathVariable("id") Long id ) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }


    @PostMapping("audit")
    @ApiModelProperty("商家入驻审核")
    public  ObjectRestResponse audit(@RequestBody VehicleApply vehicleApply) {
        baseBiz.audit(vehicleApply);
        return ObjectRestResponse.succ();
    }


    @PostMapping("apply")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse apply(@RequestBody Vehicle vehicle) {

        if (vehicle.getSubordinateBranch() == null || vehicle.getSubordinateBranch() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                vehicle.setSubordinateBranch(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ(baseBiz.saveApply(vehicle));
    }


    @GetMapping("shop/apply/selectList")
    @ApiModelProperty("列表")
    public  ObjectRestResponse shopApplySelectList(VehicleApplyFindDTO vehicleApplyFindDTO) {
        setPowerData(vehicleApplyFindDTO);
        return  baseBiz.selectList(vehicleApplyFindDTO);
    }








}
