package com.xxfc.platform.order.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.entity.OrderInvoice;
import com.xxfc.platform.order.pojo.dto.OrderDTO;
import com.xxfc.platform.order.pojo.dto.OrderDetailDTO;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by ace on 2017/9/15.
 */
@FeignClient(name = "xx-order")
public interface OrderFeign {
    @GetMapping("/baseOrder/count")
    public ObjectRestResponse<Integer> baseOrderCount(@RequestParam("hasMemberRight") Integer hasMemberRight, @RequestParam("multiStatus") String multiStatus, @RequestParam("multiTypes") String multiTypes, @RequestParam("userId") Integer userId);

    @GetMapping("/count/list")
    public ObjectRestResponse<List<OrderPageVO>> getOrderList(@RequestParam("dateTime")Long dateTime, @RequestParam("type")Integer type, @RequestParam("status")Integer status);


     @GetMapping(value = "/count/basebase/findByOrderIds")
     public ObjectRestResponse<List<OrderDTO>> findOrdersByorderId(@RequestParam(value = "orderIds") List<Integer> orderIds);



    @PostMapping(value = "/order/invoice/updateByOrderId")
    ObjectRestResponse updateByOrderId(@RequestBody OrderInvoice orderInvoice);

    @PostMapping(value = "/count/basebase/findOrdersByorderIdV2")
    ObjectRestResponse<List<OrderDTO>> findOrdersByorderIdV2(@RequestBody List<Integer> orderIds);


    @GetMapping(value = "chw/specialRent/app/unauth/checkHasSpecialRentFegin")
    ObjectRestResponse<Boolean> checkHasSpecialRentFegin(String vehicleId);


    @PostMapping(value = "chw/specialRent/app/unauth/checkHasSpecialRentFeginV2")
    ObjectRestResponse<Boolean> checkHasSpecialRentFeginV2(@RequestBody String vehicleId);


    @RequestMapping(value = "chw/orderDetail/app/unauth/getOrderDetail", method = RequestMethod.GET)
    ObjectRestResponse<OrderDetailDTO> getOrderDetail(@RequestParam("orderNo")String orderNo, @RequestParam("type")Integer type);

}
