package com.xxfc.platform.order.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Administrator
 */

@Data
@ApiModel(value = "历史订单统计实体")
public class OrderStatistics {




    /**
     * 历史交总金额
     */
    @ApiModelProperty(value = "历史交易总金额")
    private BigDecimal totalGmv=BigDecimal.ZERO;

    /**
     * 历史押金总额
     */
    @ApiModelProperty(value = "历史押金总额")
    private BigDecimal totalSecurityDeposit=BigDecimal.ZERO;

    /**
     * 历史退还押金总额
     */
    @ApiModelProperty(value = "历史退还押金总额")
    private BigDecimal totalRefundSecurityDeposit=BigDecimal.ZERO;

    /**
     * 历史赔偿总额
     */
    @ApiModelProperty(value = "历史赔偿总额")
    private BigDecimal totalCompensation=BigDecimal.ZERO;

    /**
     * 历史违章总额
     */
    @ApiModelProperty(value = "历史违章总额")
    private BigDecimal totalForfeit=BigDecimal.ZERO;


    /**
     * 历史订单退款
     */
    @ApiModelProperty(value = "历史订单退款")
    private BigDecimal totalReturnGmv=BigDecimal.ZERO;

    /**
     * 历史延期扣款总额
     */
    @ApiModelProperty(value = "历史延期扣款总额")
    private BigDecimal totalDefaultMoney=BigDecimal.ZERO;

    /**
     * 订单补偿总额
     */
    @ApiModelProperty(value = "历史订单补偿总额")
    private BigDecimal totalOrderCompensation=BigDecimal.ZERO;

    @Override
    public String toString() {
        return "OrderStatistics{" +
                "totalGmv=" + totalGmv +
                ", totalSecurityDeposit=" + totalSecurityDeposit +
                ", totalRefundSecurityDeposit=" + totalRefundSecurityDeposit +
                ", totalCompensation=" + totalCompensation +
                ", totalForfeit=" + totalForfeit +
                ", totalReturnGmv=" + totalReturnGmv +
                ", totalDefaultMoney=" + totalDefaultMoney +
                ", totalOrderCompensation=" + totalOrderCompensation +
                '}';
    }
}
