package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleHolidayPriceInfo;
import com.xxfc.platform.vehicle.mapper.VehicleHolidayPriceInfoMapper;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 车辆节假日价格信息表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-05-11 09:16:23
 */
@Service
public class VehicleHolidayPriceInfoBiz extends BaseBiz<VehicleHolidayPriceInfoMapper, VehicleHolidayPriceInfo> {

	public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");

	@Autowired
	VehicleBiz vehicleBiz;

	public ObjectRestResponse addOrUpdate(VehicleHolidayPriceInfo vehicleHolidayPriceInfo ) {
		if (vehicleHolidayPriceInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		Vehicle vehicle = vehicleBiz.get(vehicleHolidayPriceInfo.getVehicleId());
		if (vehicle == null) {
			return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "车辆不存在！");
		}
		vehicleHolidayPriceInfo.setCompanyId(vehicle.getSubordinateBranch());
		List<Vehicle> vehicleList = null;
		if (vehicleHolidayPriceInfo.getAllVehicleUse() != null && vehicleHolidayPriceInfo.getAllVehicleUse() == 1) {//所有车辆可用
			vehicleList = vehicleBiz.getAllVehicleByCompanyId(vehicle.getSubordinateBranch(), null);
		}
		if (vehicleHolidayPriceInfo.getAllModelUse() != null && vehicleHolidayPriceInfo.getAllModelUse() == 1) {//所有车型可用
			vehicleList = vehicleBiz.getAllVehicleByCompanyId(vehicle.getSubordinateBranch(), null);
		}
		if (vehicleList == null || vehicleList.size() <= 0) { //单个车辆可用
			for(String date : getAllDate(vehicleHolidayPriceInfo.getStartDate(), vehicleHolidayPriceInfo.getEndDate())) {
				vehicleHolidayPriceInfo.setFestivalDate(DateTime.parse(date, DATE_TIME_FORMATTER).toDate());
				VehicleHolidayPriceInfo oldValue = getByVehicleId(vehicleHolidayPriceInfo.getVehicleId(),  date);
				if (oldValue == null) {
					vehicleHolidayPriceInfo.setId(null);
					insertSelectiveRe(vehicleHolidayPriceInfo);
				} else {
					BeanUtil.copyProperties(vehicleHolidayPriceInfo, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
					updateSelectiveByIdRe(oldValue);
				}
			}

		}  else {
			vehicleList.parallelStream().forEach(vehicleInfo -> {
				for(String date : getAllDate(vehicleHolidayPriceInfo.getStartDate(), vehicleHolidayPriceInfo.getEndDate())) {
					VehicleHolidayPriceInfo oldValue = getByVehicleId(vehicleInfo.getId(),  date);
					vehicleHolidayPriceInfo.setFestivalDate(DateTime.parse(date, DATE_TIME_FORMATTER).toDate());
					vehicleHolidayPriceInfo.setVehicleId(vehicleInfo.getId());
					vehicleHolidayPriceInfo.setCompanyId(vehicleInfo.getSubordinateBranch());
					vehicleHolidayPriceInfo.setModelId(vehicleInfo.getModelId());
					vehicleHolidayPriceInfo.setId(null);
					if (oldValue == null) {
						insertSelectiveRe(vehicleHolidayPriceInfo);
					} else {
						BeanUtil.copyProperties(vehicleHolidayPriceInfo, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
						updateSelectiveByIdRe(oldValue);
					}
				}
			});
		}
		return ObjectRestResponse.succ();
	}

	public VehicleHolidayPriceInfo getByVehicleId(String vehicleId, String date) {
		Example example = new Example(VehicleHolidayPriceInfo.class);
		example.createCriteria().andEqualTo("vehicleId", vehicleId).andEqualTo("festivalDate", date);
		return mapper.selectOneByExample(example);
	}


	//获取所有车的价格
	public ObjectRestResponse<List<VehicleHolidayPriceInfo>> getAllByVehicleIds(List<VehicleHolidayPriceInfo> list) {
		if (list == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		List<VehicleHolidayPriceInfo> vehicleHolidayPriceInfoList = new ArrayList<>();
		if (list.size() > 0) {
			for (VehicleHolidayPriceInfo vehicleHolidayPriceInfo : list) {
				vehicleHolidayPriceInfoList.addAll(getByVehicleIdAndDate(vehicleHolidayPriceInfo.getVehicleId(), vehicleHolidayPriceInfo.getStartDate(), vehicleHolidayPriceInfo.getEndDate()));
			}
		}
		return ObjectRestResponse.succ(vehicleHolidayPriceInfoList);
	}


	public List<VehicleHolidayPriceInfo> getByVehicleIdAndDate (String vehicleId, String startDate, String endDate) {
		Example example = new Example(VehicleHolidayPriceInfo.class);
		example.createCriteria().andEqualTo("vehicleId", vehicleId).andBetween("festivalDate", startDate, endDate);
		return mapper.selectByExample(example);
	}


	//获取当前车辆所有的节日价格
	public ObjectRestResponse<List<VehicleHolidayPriceInfo>> getByVehicleId (String vehicleId) {
		Example example = new Example(VehicleHolidayPriceInfo.class);
		example.createCriteria().andEqualTo("vehicleId", vehicleId);
		return ObjectRestResponse.succ(mapper.selectByExample(example));
	}




	public static Set<String> getAllDate(String startDate, String endDate) {
		Set<String> list = new HashSet<>();
		DateTime startTime = DateTime.parse(startDate, DATE_TIME_FORMATTER);
		DateTime endTime = DateTime.parse(endDate, DATE_TIME_FORMATTER);
		list.add(startDate);
		list.add(endDate);
		if (endTime.getMillis() - startTime.getMillis() > 24 * 3600 * 1000) { //
			for (DateTime curDate = startTime.plusDays(1); curDate.compareTo(endTime) < 0; curDate = curDate.plusDays(1)) {
				list.add(curDate.toString(DATE_TIME_FORMATTER));
			}
		} else {
			list.add(startDate);
		}
		return list;
	}
}