package com.xxfc.platform.order.pojo.bo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2020/1/6 11:21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MemberStatisticsPageBo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 会员订单数
     */
    private long memberOrdersNum;
    /**
     * 新增会员人数
     */
    private long newMembersNum;
    /**
     * 激活人数
     */
    private long activateMembersNum;
    /**
     * 会员费
     */
    private BigDecimal memberAmount = BigDecimal.ZERO;
    /**
     * 普通会员订单数
     */
    private long commonMemberOrdersNum;
    /**
     * 普通会员订单金额
     */
    private BigDecimal commonMemberOrderAmount = BigDecimal.ZERO;
    /**
     * 黄金会员订单数
     */
    private long goldMemberOrdersNum;
    /**
     * 黄金会员订单金额
     */
    private BigDecimal goldMemberOrderAmount = BigDecimal.ZERO;
    /**
     * 钻石会员订单数
     */
    private long diamondMemberOrdersNum;
    /**
     * 钻石会员订单金额
     */
    private BigDecimal diamondMemberOrderAmount = BigDecimal.ZERO;
    /**
     * 会员统计
     */
    private List<MemberStatisticsBo> memberStatistics;


    private Long totalCount;

    private Integer totalPage;

    private Integer pageNum;

    private Integer pageSize;


    public List<MemberStatisticsBo> getMemberStatistics() {
        return CollectionUtils.isEmpty(memberStatistics)? Collections.EMPTY_LIST:memberStatistics;
    }
}
