package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Data
@Table(name = "order_active_detail")
public class OrderActiveDetail {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键")
    private Integer id;

    @Column(name = "crt_time")
    private Date crtTime;

    @Column(name = "upd_time")
    private Date updTime;

    /**
     * 订单ID
     */
    @Column(name = "order_id")
    private Integer orderId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private Long productId;

    /**
     * 产品规格json
     */
    @Column(name = "product_specs")
    private String productSpecs;

    /**
     * 购买数量
     */
    private Integer number;

    /**
     * 规格ID
     */
    @Column(name = "specs_id")
    private Long specsId;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 1、优惠券
     */
    private Integer type;
}