package com.xxfc.platform.tour.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.TourGoodVerification;
import com.xxfc.platform.tour.entity.TourUser;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-tour")
public interface TourFeign {
    public static final int STOCK_SUBTRACT = 1;
    public static final int STOCK_PLUS = 2;

    public static final String TOTAL_PERSON = "total_person";

    /**
     * 计算价格
     * @param spePriceDto
     * @return
     */
    @RequestMapping(value = "/spe/user/prices", method = RequestMethod.POST)
    public ObjectRestResponse<TourSpePriceVo> refund(@RequestBody TourSpePriceDTO spePriceDto);

    /**
     *
     * @param speId
     * @param number
     * @param type 1--减库存，2--加库存
     * @return
     */
    @RequestMapping(value = "/spe/stock", method = RequestMethod.GET)
    public ObjectRestResponse<TourSpePriceVo> stock(@RequestParam("speId") Integer speId, @RequestParam("number") Integer number, @RequestParam("type") Integer type);


    @RequestMapping(value = "/tourGood/app/unauth/usable/{id}", method = RequestMethod.GET)
    public ObjectRestResponse<TourGood> usableGet(@PathVariable(value = "id") int id);

    @GetMapping("/tourUser/app/unauth/getTourUsers")
    public ObjectRestResponse<List<TourUser>> getTourUsers(@RequestParam("ids")  String ids);

    @GetMapping("/tourGood/verfication/entityList")
    public ObjectRestResponse<List<TourGoodVerification>> entityList(@RequestParam("entity") Map<String, Object> entity);

    /**
     * 更新发车状态
     * @param verficationId
     * @return
     */
    @PutMapping("/tourGood/verfication/status")
    ObjectRestResponse<Void> updateTourGoodVerificationStatus(@RequestParam("verficationId") Integer verficationId);

    /**
     * 更新总人数或上车人数
     * @param verficationId
     * @param properties
     * @return
     */
    @PutMapping("/tourGood/verfication/personnums")
    ObjectRestResponse<Void> updateTourGoodPersonNum(@RequestParam("verficationId") Integer verficationId,@RequestParam("properties") String properties,@RequestParam("number") Integer number);

    /**
     * 查询订单列表
     * @param tourGoodOrderFindVo
     * @return
     */
    @RequestMapping(value = "/tourGood/verfication/orders", method = RequestMethod.POST)
    PageDataVO<TourGoodOrderVo> findTourGoodOrders(@RequestBody TourGoodOrderFindVo tourGoodOrderFindVo);

    @ApiOperation("首页旅游列表")
    @GetMapping(value = "/tourGood/app/shopList")
    public List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit",defaultValue = "4") Integer limit);

    //获取商品信息
    @RequestMapping(value = "/good/app/unauth/one", method = RequestMethod.GET)
    public TourGood one(@RequestParam(value = "goodId",defaultValue = "0") Integer goodId);

    @GetMapping("/tourGoodSite/departure_time")
    Long selectDepartureTimeByStartCompanyIdAndRouteId(@RequestParam(value = "companyId") Integer companyId, @RequestParam(value = "goodId") Integer routeId);

    @GetMapping("/tourGood/verfication/departure_status")
    Integer selectDepartureStatusByVerificationId(@RequestParam(value = "verificationId") Integer verificationId);

    @GetMapping("/spe/departure_date")
    Date selectDepartureDataBySpeId(@RequestParam(value = "speIds") Integer speIds);

    @GetMapping(value = "/tourGood/app/unauth/findRandomVehicle")
    public ObjectRestResponse findRandomVehicle(@RequestParam(value = "number")Integer number);
}
