package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.entity.IntegralRule;
import com.xxfc.platform.activity.entity.IntegralUserStatus;
import com.xxfc.platform.activity.mapper.IntegralRuleMapper;
import com.xxfc.platform.activity.user.UserInfoBiz;
import com.xxfc.platform.activity.vo.IntegralRuleDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class IntegralRuleBiz extends BaseBiz<IntegralRuleMapper, IntegralRule> {

    @Autowired
    UserInfoBiz userInfoBiz;
    @Autowired
    IntegralUserRecordBiz integralUserRecordBiz;
    @Autowired
    IntegralUserStatusBiz integralUserStatusBiz;
    /**
     * 添加、更新积分规则
     * @param integralRule
     * @return
     */
    public ObjectRestResponse add(IntegralRule integralRule) {
        if(integralRule == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if(integralRule.getId() != null) {//已存在，更新
            IntegralRule oldValue = mapper.selectByPrimaryKey(integralRule.getId());
            if(oldValue == null) {
                return ObjectRestResponse.createDefaultFail();
            }
            BeanUtil.copyProperties(integralRule, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateByIdRe(oldValue);
            return ObjectRestResponse.succ();
        }
       insertSelective(integralRule);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除积分规则
     * @param id
     * @return
     */
    public ObjectRestResponse deleteOne(Integer id) {
        if(id == null || id < 0) {
            return ObjectRestResponse.paramIsEmpty();
        }
        IntegralRule oldValue = mapper.selectByPrimaryKey(id);
        if(oldValue == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        oldValue.setIsdel(true);
        updateByIdRe(oldValue);
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse<IntegralRule> getOne(IntegralRuleDto integralRule) {
        if(integralRule == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        List<IntegralRule> oldValue = mapper.selectAllByParam(integralRule);
        if(oldValue != null && oldValue.size() > 0) {
            return ObjectRestResponse.succ(oldValue.get(0));
        }
        return ObjectRestResponse.succ();
    }


    public ObjectRestResponse<PageDataVO>  getAll(IntegralRuleDto integralRule) {

        Query query = new Query(integralRule);
        PageDataVO pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectAllByParam(integralRule));
        //添加个人积分状态

        return ObjectRestResponse.succ(pageDataVO);
    }

    public ObjectRestResponse<PageDataVO>  getList(IntegralRuleDto integralRule) {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        Query query = new Query(integralRule);
        PageDataVO<IntegralRule> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectAllByParam(integralRule));
        //添加个人积分状态
        pageDataVO.getData().forEach((a) -> getIntegralStatus(appUserDTO, a));
        return ObjectRestResponse.succ(pageDataVO);
    }


    public void  getIntegralStatus(AppUserDTO appUserDTO, IntegralRule integralRule) {
            List<IntegralUserStatus> oldValue = integralUserStatusBiz.selectByUserAndCode(integralRule.getCode(), appUserDTO.getUserid());
            if(oldValue != null && oldValue.size() > 0) {
                integralRule.setIntegralStatus(oldValue.get(0).getIntegralStatus());
            }
    }


}
