package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.mapper.VehicleModelMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 车型
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-21 14:15:27
 */
@Service
@Slf4j
public class VehicleModelBiz extends BaseBiz<VehicleModelMapper, VehicleModel> {


    //添加评分
    public void addScore(Integer id, Integer score) {
        VehicleModel model = new VehicleModel();
        model.setId(id);
        model.setScore(score);
        updateSelectiveById(model);
    }

    public ObjectRestResponse findVehicleModelPage(VehicleModelQueryCondition vmqc) {

//        List<VehicleModelVo > vehicleModelPage = mapper.findVehicleModelPage(vmqc);

//    log.debug("vehicleModelPage"+vehicleModelPage);


        try {
            PageDataVO<VehicleModel> mPageDataVO = PageDataVO.pageInfo(vmqc.getPage(),
                    vmqc.getLimit(), () -> mapper.findVehicleModelPage(vmqc));

            return ObjectRestResponse.succ(mPageDataVO);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ObjectRestResponse.createDefaultFail();

    }


    public Integer insertAndGetId(VehicleModel vm) {
        try {
            mapper.insertSelective(vm);
            return vm.getId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;

    }

}