package com.xxfc.platform.tour.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourBannerBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.entity.TourBanner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;


/**
 * @author libin
 * @version 1.0
 * @description banner 图
 * @data 2019/6/12 21:15
 */
@RestController
@RequestMapping("/admin/tourBanner")
@Api(value = "banner后台接口")
public class TourBannerAdminController extends TourBaseController<TourBannerBiz> {

    /**
     * 修改
     * @param banner
     * @return
     */
    @PutMapping
    @ApiOperation(value = "banner修改",notes = "修改")
    public ObjectRestResponse<TourBanner> update(@RequestBody TourBanner banner){
        int effectRows = getBaseBiz().update(banner,userinfoByToken());
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    /**
     * 根据id查询banner
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询banner图",notes = "根据id查询banner图")
    public ObjectRestResponse<TourBanner> findTourBannerById(@PathVariable Integer id){
        TourBanner tourBanner = getBaseBiz().selectById(id);
        return ObjectRestResponse.succ(tourBanner);
    }

    /**
     * 分布查询banner
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "banner分页查询",notes = "banner分页查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "pageNo",paramType = "query",required = false,dataType = "integer",defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize",paramType = "query",required = false,dataType = "integer",defaultValue = "10")
    })
    public ObjectRestResponse<PageDataVO> findTourBannerPage(@RequestParam(name = "pageNo",defaultValue = "0",required = false) Integer pageNo,
                                                             @RequestParam(name = "pageSize",defaultValue = "10",required = false) Integer pageSize){

        PageDataVO<TourBanner> pageDataVO = getBaseBiz().findBannePage(pageNo,pageSize);

        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 保存banner
     * @param banner
     * @return
     */
    @ApiOperation(value = "banner保存",notes = "banner保存")
    @PostMapping
    public ObjectRestResponse<Void> saveTourBanner(@RequestBody TourBanner banner){
        banner.setIsDel(0);
        int effectRows = getBaseBiz().save(banner,userinfoByToken());
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();

    }


    /**
     * 逻辑删除
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "banner逻辑删除",notes = "banner逻辑删除")
    public ObjectRestResponse<Void> deleteBannerById(@PathVariable Integer id){

        int effectRows = getBaseBiz().updateBannerStatus(id,1,userinfoByToken());
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

}