package com.xxfc.platform.tour.common;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class TourBaseController<Biz extends BaseBiz> extends CommonBaseController {
    
    @Autowired
    protected Biz baseBiz;
    @Autowired
    protected UserFeign userFeign;
    @Autowired
    protected UserAuthConfig userAuthConfig;


  public AppUserDTO getUserInfo(){
      return  userFeign.userDetailByToken(userAuthConfig.getToken(request)).getData();
  }
    public Biz getBaseBiz() {
        return baseBiz;
    }

    public UserDTO userinfoByToken(){
        return userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
    }
}
