package com.xxfc.platform.tour.biz;

import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.sun.org.apache.regexp.internal.RE;
import com.xxfc.platform.tour.dto.GoodSiteDTO;
import com.xxfc.platform.tour.dto.GoodSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.TourGoodSite;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import  com.xxfc.platform.tour.entity.TourGoodVerification;
import  com.xxfc.platform.tour.mapper.TourGoodVerificationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 旅游线路核销明细
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-14 09:36:50
 */
@Service
public class TourGoodVerificationBiz extends BaseBiz<TourGoodVerificationMapper,TourGoodVerification> {

     @Autowired
     private TourGoodSiteBiz tourGoodSiteBiz;

     @Autowired
     private TourGoodBiz tourGoodBiz;

     @Autowired
     private TourGoodSpeBiz tourGoodSpeBiz;


    //删除线路核销
    public  void delGoodVerification(List<Integer> ids){ mapper.delVerification(ids);}

    /**
     * 批量插入核销
     * @param tourGoodVerifications
     */
    public  void addBathTourGoodVerification(List<TourGoodVerification> tourGoodVerifications){
        for (TourGoodVerification tourGoodVerification:tourGoodVerifications){
            mapper.insertTourGoodVerification(tourGoodVerification);
        }
    }

    /**
     * 分页查询订单列表
     * @param tourGoodOrderFindVo
     * @return
     */
    public PageDataVO<TourGoodOrderVo> findTourGoodOrdersPage(TourGoodOrderFindVo tourGoodOrderFindVo) {
        return null;
    }


    /**
     * 更改发车状态
      * @param verficationId
     * @return
     */
    public int updateTourGoodVerificationStatus(Integer verficationId){
        return mapper.updateStatusByGoodIdAndSpeIdAndSiteId(verficationId,0);
    }

    /**
     * 更新总人数 或 上车人数
      * @param verficationId
     * @param properties
     * @return
     */
    public int updateTourGoodPersonNum(Integer verficationId,String properties){

         return mapper.updateTourGoodPerNumbs(verficationId,properties);
    }
}