package com.xxfc.platform.tour.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author libin
 * @version 1.0
 * @description 旅游订单列表
 * @data 2019/6/14 15:19
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TourGoodOrderVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品名称
     */
     private String name;

    /**
     * 封面
     */
    private String coverUrl;

    /**
     * 出行时间
     */
    private String travelTime;

    /**
     * 总人数
     */
    private int  headcount;

    /**
     * 未上车人数
     */
    private int  tripOfNum;

    /**
     * 已上车人数
     */
    private  int  leaveOfnum;

    /**
     * 分公司名称
     */
    private  String companyName;

    /**
     * 是否出行  '状态：0-未出行；1-已出行'
     */
    private  Integer  travelStatus;
}
