package com.xxfc.platform.tour.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.TourGoodVerification;
import com.xxfc.platform.tour.entity.TourUser;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-tour")
public interface TourFeign {

    /**
     * 计算价格
     * @param spePriceDto
     * @return
     */
    @RequestMapping(value = "/spe/user/prices", method = RequestMethod.POST)
    public ObjectRestResponse<TourSpePriceVo> refund(@RequestBody TourSpePriceDTO spePriceDto);

    @RequestMapping(value = "/spe/stock", method = RequestMethod.GET)
    public ObjectRestResponse<TourSpePriceVo> stock(@RequestParam Integer speId, @RequestParam Integer number);


    @RequestMapping(value = "/tourGood/app/unauth/usable/{id}", method = RequestMethod.GET)
    public ObjectRestResponse<TourGood> usableGet(@PathVariable int id);

    @GetMapping("/tourUser/app/unauth/getTourUsers")
    public ObjectRestResponse<List<TourUser>> getTourUsers(@RequestParam  String ids);

    @GetMapping("/tourGoodVerification/entityList")
    public ObjectRestResponse<List<TourGoodVerification>> entityList(@RequestParam Map<String, Object> entity);

    /**
     * 更新发车状态
     * @param verficationId
     * @return
     */
    @PutMapping("/tourGood/verfication/status")
    ObjectRestResponse<Void> updateTourGoodVerificationStatus(@RequestParam("verficationId") Integer verficationId);

    /**
     * 更新总人数或上车人数
     * @param verficationId
     * @param properties
     * @return
     */
     @PutMapping("/tourGood/verfication/personnums")
     ObjectRestResponse<Void> updateTourGoodPersonNum(@RequestParam("verficationId") Integer verficationId,String properties);

    /**
     * 查询订单列表
     * @param tourGoodOrderFindVo
     * @return
     */
    @GetMapping("/orders")
    public ObjectRestResponse<PageDataVO<TourGoodOrderVo>> findTourGoodOrders(TourGoodOrderFindVo tourGoodOrderFindVo);
}
