package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.biz.OrderTourDetailBiz;
import com.xxfc.platform.order.biz.OrderTourVerificationBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.order.pojo.AddTourDTO;
import com.xxfc.platform.order.pojo.order.TourBO;
import com.xxfc.platform.order.pojo.price.TourPriceVO;
import com.xxfc.platform.order.service.OrderTourService;
import com.xxfc.platform.tour.feign.TourFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("tour")
@IgnoreClientToken
@Api(value="旅游订单核销",tags={"旅游订单核销"})
public class OrderTourVerificationController extends CommonBaseController {

    @Autowired
    OrderTourVerificationBiz verificationBiz;

    @Autowired
    TourFeign tourFeign;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    UserFeign userFeign;

    public AppUserDTO getUserInfo(){
        return  userFeign.userDetailByToken(userAuthConfig.getToken(request)).getData();
    }

    @RequestMapping(value = "/verification/orderlist",method = RequestMethod.GET)
    @ApiOperation(value = "旅游核销订单列表")
    public ObjectRestResponse orderlist(
           @RequestParam(value = "page",defaultValue = "1") Integer page,
           @RequestParam(value = "limit",defaultValue = "10") Integer limit,
           @RequestParam(value = "verificationId",defaultValue = "0") Integer verificationId
    ){
        return ObjectRestResponse.succ(verificationBiz.getVerificationList(page,limit,verificationId));
    }
    @RequestMapping(value = "/verification/check",method = RequestMethod.POST)
    @ApiOperation(value = "旅游核销")
    public ObjectRestResponse<BaseOrder> check(
            @RequestParam(value = "orderId",defaultValue = "0") Integer orderId
    ){
        return verificationBiz.VerificationByOrder(orderId);
    }

    @RequestMapping(value = "/verification/finish",method = RequestMethod.POST)
    @ApiOperation(value = "确定发车")
    public ObjectRestResponse<BaseOrder> finishOrder(
            @RequestParam(value = "verificationId",defaultValue = "0") Integer verificationId
    ){
        return verificationBiz.finishByOrder(verificationId);
    }

    @RequestMapping(value = "/verification/list",method = RequestMethod.GET)
    @ApiOperation(value = "旅游核销订单列表")
    public ObjectRestResponse list(
            @RequestParam(value = "page",defaultValue = "1") Integer page,
            @RequestParam(value = "limit",defaultValue = "10") Integer limit,
            @RequestParam(value = "verificationId",defaultValue = "0") Integer verificationId
    ){
        return ObjectRestResponse.succ(verificationBiz.getVerificationList(page,limit,verificationId));
    }





}