package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.service.OrderRentVehicleService;
import com.xxfc.platform.order.pojo.AddRentVehicleDTO;
import com.xxfc.platform.order.pojo.order.RentVehicleBO;
import com.xxfc.platform.order.pojo.price.RentVehiclePriceVO;
import com.xxfc.platform.vehicle.pojo.BookVehicleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping("orderRentVehicle")
@Api(value="租车订单",tags={"租车订单"})
@IgnoreClientToken
public class OrderRentVehicleController extends CommonBaseController {

        @Autowired
        OrderRentVehicleService orderRentVehicleService;

        @Autowired
        OrderRentVehicleBiz orderRentVehicleBiz;

        @Autowired
        BaseOrderBiz baseOrderBiz;

        @RequestMapping(value = "add",method = RequestMethod.POST)
        @ResponseBody
        @ApiOperation(value = "确认租车订单")
        public ObjectRestResponse<BaseOrder> add(@RequestBody AddRentVehicleDTO vo){
            RentVehicleBO bo = BeanUtil.toBean(vo, RentVehicleBO.class);
            bo.setBookVehicleVO(new BookVehicleVO(){{
                    setBookStartDate(vo.getBookStartDate());
                    setBookEndDate(vo.getBookEndDate());
            }});
            orderRentVehicleService.createOrder(bo);
            return ObjectRestResponse.succ(bo.getOrder());
        }

        @RequestMapping(value = "list-by-order/{orderId}",method = RequestMethod.GET)
        @ResponseBody
        @ApiOperation(value = "租车列表by订单Id")
        public ObjectRestResponse<OrderRentVehicleDetail> listByOrder(@PathVariable("orderId") Integer orderId){
                return ObjectRestResponse.succ(orderRentVehicleBiz.listByOrderId(orderId));
        }

        @RequestMapping(value = "/app/unauth/calculate-price",method = RequestMethod.GET)
        @ResponseBody
        @ApiOperation(value = "价格计算")
        @IgnoreUserToken
        public ObjectRestResponse<RentVehiclePriceVO> calculatePrice(CalculatePriceVO vo){
                RentVehicleBO bo = BeanUtil.toBean(vo, RentVehicleBO.class);
                return ObjectRestResponse.succ(orderRentVehicleService.calculatePrice(bo));
        }

        @Data
        public class CalculatePriceVO {
                @ApiModelProperty(value = "司机类型 1--公司司机；2--自己司机")
                private Integer driverType;

                @ApiModelProperty(value = "车型id")
                private Integer modelId;

                //开始时间
                @ApiModelProperty(value = "开始时间")
                private Long startTime;

                //结束时间
                @ApiModelProperty(value = "结束时间")
                private Long endTime;

                @ApiModelProperty(value = "天数")
                private Integer dayNum;

                //是否购买免赔
                @ApiModelProperty(value = "是否购买免赔 1--是")
                private Integer damageSafe;

        }
}