package com.xxfc.platform.vehicle.pojo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class RentVehicleBookDTO extends PageParam {
    //根据车型、时间、距离，门店，预定车辆
    @ApiModelProperty("车型id")
    private Integer modelId;
    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标日期(开始)")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标日期(结束)")
    private String bookEndDate;

    /**
     * 提车地点
     */
    @ApiModelProperty("提车地点")
    private String liftAddr;

    /**
     * 提车公司
     */
    @ApiModelProperty("提车公司")
    private Integer liftCompany;

    /**
     * 还车分公司
     */
    @ApiModelProperty("还车分公司")
    private Integer retCompany;

    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String destination;

    /**
     *  用户名
     */
    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("停靠公司id")
    Integer parkBranchCompanyId;

    /**
     * 随车物品id以及数量 List<Map<id,数量>>
     */
    @ApiModelProperty("随车物品id以及数量 List<Map<id,数量>>")
    Map<Integer,Integer> selectedAccItem;
}