package com.xxfc.platform.user.behavior.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.activity.dto.ActivityListDTO;
import com.xxfc.platform.activity.dto.ActivityPopularizeRelationDTO;
import com.xxfc.platform.activity.feign.ActivityFeign;
import com.xxfc.platform.user.behavior.common.BehaviorEnum;
import com.xxfc.platform.user.behavior.dto.ActivityBehaviorDTO;
import com.xxfc.platform.user.behavior.dto.BehaviorTypeDTO;
import com.xxfc.platform.user.behavior.dto.CustomerBehaviorNoteDTO;
import com.xxfc.platform.user.behavior.entity.CustomerBehaviorNotes;
import com.xxfc.platform.user.behavior.mapper.CustomerBehaviorNotesMapper;
import com.xxfc.platform.user.behavior.vo.BehaviorNoteCollectVo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 用户行为记录表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-12 14:03:55
 */
@Service
@RequiredArgsConstructor(onConstructor = @__({@Autowired}))
public class CustomerBehaviorNotesBiz extends BaseBiz<CustomerBehaviorNotesMapper, CustomerBehaviorNotes> {

    private final ActivityFeign activityFeign;

    private final BehaviorTypeBiz behaviorTypeBiz;

    private final ActivityBehaviorBiz activityBehaviorBiz;

    public void saveCustomerBehavior(CustomerBehaviorNoteDTO customerBehaviorNoteDTO) {
        CustomerBehaviorNotes customerBehaviorNotes = new CustomerBehaviorNotes();
        BeanUtils.copyProperties(customerBehaviorNoteDTO, customerBehaviorNotes);
        customerBehaviorNotes.setCrtTime(Instant.now().toEpochMilli());
        mapper.insertSelective(customerBehaviorNotes);
    }

    public List<BehaviorNoteCollectVo> findBehaviorCollectByActivityId(Integer activityId, Long startTime, Long endTime) {

        List<BehaviorNoteCollectVo> behaviorNoteCollectVos = new ArrayList<>();
        List<CustomerBehaviorNotes> customerBehaviorNotes = mapper.selectByActivityIdAndTime(activityId, startTime, endTime);

        boolean isEmpty = CollectionUtils.isEmpty(customerBehaviorNotes);
        List<ActivityPopularizeRelationDTO> popularizeRelations = new ArrayList<>();
        Map<Integer, List<CustomerBehaviorNotes>> behaviorAndDataMap = null;
        if (!isEmpty) {
            //邀请成功记录
            popularizeRelations = activityFeign.findActivityPopularizeRelationByActivityIdAndTime(activityId, startTime, endTime);
            behaviorAndDataMap = customerBehaviorNotes.stream().collect(Collectors.groupingBy(CustomerBehaviorNotes::getType, Collectors.toList()));
        }

        //获取时间间隔
        long between_day = getBetween_day(activityId, startTime, endTime);

        between_day = Math.abs(between_day) == 0 ? 1 : Math.abs(between_day);
        List<ActivityBehaviorDTO> activityBehaviorDTOS = activityBehaviorBiz.findActivityBehaviorsByActivityId(activityId);
        List<Integer> behaviorTypeIds = activityBehaviorDTOS.stream().map(ActivityBehaviorDTO::getBehaviorTypeId).collect(Collectors.toList());
        List<BehaviorTypeDTO> behaviorTypeDTOS = behaviorTypeBiz.findBehaviorTypesByIds(behaviorTypeIds);
        List<Integer> behaviorCodes = behaviorTypeDTOS.stream().map(BehaviorTypeDTO::getCode).collect(Collectors.toList());
        Set<BehaviorEnum> behaviorEnums = EnumSet.allOf(BehaviorEnum.class).stream().filter(behaviorEnum -> behaviorCodes.contains(behaviorEnum.getCode())).collect(Collectors.toSet());
        Map<Integer, String> codeAndName = behaviorTypeDTOS.stream().collect(Collectors.toMap(BehaviorTypeDTO::getCode, BehaviorTypeDTO::getName));
        BehaviorNoteCollectVo behaviorNoteCollectVo;

        for (BehaviorEnum behaviorEnum : behaviorEnums) {
            behaviorNoteCollectVo = new BehaviorNoteCollectVo();
            behaviorNoteCollectVo.setBehavior(codeAndName.get(behaviorEnum.getCode()));
            if (isEmpty) {
                behaviorNoteCollectVos.add(behaviorNoteCollectVo);
                continue;
            } else {
                long default_p_total, default_p_avg, default_u_total, default_u_avg;
                switch (behaviorEnum) {
                    case SUCCESS_INVIT:
                        default_p_total = popularizeRelations.size();
                        default_p_avg = (default_p_total / between_day);
                        default_u_total = default_p_total;
                        default_u_avg = default_p_avg;
                        break;
                    case SUCCESS_MORE_10_INVIT:
                        default_p_total = popularizeRelations.stream().collect(Collectors.groupingBy(ActivityPopularizeRelationDTO::getMajorUserId, Collectors.counting())).values().stream().filter(x -> x >= 10).count();
                        default_p_avg = default_p_total / between_day;
                        default_u_total = default_p_total;
                        default_u_avg = default_p_avg;
                        break;
                    case APP_VISIT_COUNT:
                        default_p_total = mapper.selectAppVvisitsByType(BehaviorEnum.APP_VISIT_COUNT.getCode());
                        default_p_avg = default_p_total / between_day;
                        default_u_total = default_p_total;
                        default_u_avg = default_p_avg;
                        break;
                    default:
                        //访问量
                        List<CustomerBehaviorNotes> customerBehaviors = behaviorAndDataMap == null ? Collections.EMPTY_LIST : behaviorAndDataMap.get(behaviorEnum.getCode());
                        boolean typeIsEmpty = CollectionUtils.isEmpty(customerBehaviors);
                        default_p_total = typeIsEmpty ? 0 : customerBehaviors.size();
                        default_p_avg = default_p_total / between_day;
                        //用户访问量
                        Set<CustomerBehaviorNotes> customerBehaviorsSet = new HashSet<>(typeIsEmpty ? Collections.EMPTY_SET : customerBehaviors);
                        default_u_total = customerBehaviorsSet.size();
                        default_u_avg = default_u_total / between_day;
                        break;
                }
                behaviorNoteCollectVo.setP_count(default_p_total);
                behaviorNoteCollectVo.setP_avg_count(default_p_avg);
                behaviorNoteCollectVo.setU_count(default_u_total);
                behaviorNoteCollectVo.setU_avg_count(default_u_avg);
                behaviorNoteCollectVos.add(behaviorNoteCollectVo);
            }
        }
        return behaviorNoteCollectVos;
    }

    private long getBetween_day(Integer activityId, Long startTime, Long endTime) {
        long between_day = 0;
        if (startTime != null && endTime != null) {
            between_day = ChronoUnit.DAYS.between(Instant.ofEpochMilli(startTime), Instant.ofEpochMilli(endTime));
        } else {
            ActivityListDTO activityListDTO = activityFeign.findActivityStartTimeAndEndTimeById(activityId);
            if (startTime != null) {
                between_day = ChronoUnit.DAYS.between(Instant.ofEpochMilli(startTime), Instant.now());
            }
            if (endTime != null) {
                between_day = ChronoUnit.DAYS.between(Instant.ofEpochMilli(activityListDTO.getActivity_startTime()), Instant.ofEpochMilli(endTime));
            }
            if (startTime == null && endTime == null) {
                between_day = ChronoUnit.DAYS.between(Instant.ofEpochMilli(activityListDTO.getActivity_startTime()), Instant.now());
            }
        }
        return between_day;
    }
}