package com.xxfc.platform.user.behavior.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.user.behavior.dto.BehaviorTypeDTO;
import com.xxfc.platform.user.behavior.entity.BehaviorType;
import com.xxfc.platform.user.behavior.mapper.BehaviorTypeMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/13 14:09
 */
@Service
public class BehaviorTypeBiz extends BaseBiz<BehaviorTypeMapper, BehaviorType> {

       public List<BehaviorTypeDTO> findBehaviorTypesByIds(List<Integer> typeIds){
           List<BehaviorTypeDTO> behaviorTypeDTOS = new ArrayList<>();
           List<BehaviorType> behaviorTypes = mapper.selectByIdList(typeIds);
            BehaviorTypeDTO behaviorTypeDTO;
           for (BehaviorType behaviorType : behaviorTypes) {
               behaviorTypeDTO = new BehaviorTypeDTO();
               BeanUtils.copyProperties(behaviorType,behaviorTypeDTO);
               behaviorTypeDTOS.add(behaviorTypeDTO);
           }
           return behaviorTypeDTOS;
       }
}
