package com.xxfc.platform.user.behavior.common;

/**
 * @author libin
 * @version 1.0
 * @description 用户行为枚举
 * @data 2019/8/12 14:57
 */
public enum BehaviorEnum {

    /**
     * 弹窗曝光
     */
    DIALOG_WINDOW(0, "弹窗曝光"),

    /**
     * 立即前往（弹窗）
     */
    DIALOG_WINDOW_TO(1, "立即前往(弹窗)"),

    /**
     * banner 点击
     */
    BANNER_CLICK(2, "banner点击"),

    /**
     * 精彩活动点击
     */
    WONDERFUL_ACTIVITY_CLICK(3, "精彩活动点击"),

    /**
     * 注册
     */
    REGISTRY(4, "成功注册"),

    /**
     * 活动页面访问量
     */
    ACTIVITY_VISITS(5,"活动页面访问"),

    /**
     * 领取任务
     */
    CLAIM_TASK(6, "领取任务"),

    /**
     * 分享
     */
    SHARE(7, "成功分享"),

    /**
     * App访问
     */
    APP_VISIT_COUNT(8,"App访问量"),

    /**
     * 成功邀请人数
     */
    SUCCESS_INVIT(9,"成功邀请人数"),

    /**
     * 成功邀请人数大于10
     */
    SUCCESS_MORE_10_INVIT(10,"成功邀请人数大于10"),

    /**
     * 立即领取(活动详情页)
     */
    IMMEDIATELY_TO_RECEIVE(11,"立即领取(活动详情页)");

    BehaviorEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    private int code;

    private String name;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
