package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.biz.MQServiceBiZ;
import com.xxfc.platform.universal.dto.SendMsgDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "message")
public class MQSenderController {

    @Autowired
    private MQServiceBiZ mqServiceBiZ;

    @GetMapping(value = "/sendMessage")
    public ObjectRestResponse sendMessage(@RequestParam(value = "exchange") String exchange, @RequestParam(value = "routKey") String routKey, @RequestParam(value = "json") String json) {
        return mqServiceBiZ.sendMessage(exchange, routKey, json);
    }

    @PostMapping(value = "/sendMessage")
    @ResponseBody
    public ObjectRestResponse sendMessage(@RequestBody SendMsgDTO dto) {
        return mqServiceBiZ.sendMessage(dto.getExchange(), dto.getRoutKey(), dto.getJson());
    }


}
