package com.github.wxiaoqi.security.admin.jobhandler;


import com.github.wxiaoqi.security.admin.biz.MyWaterBiz;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;

/**
 * 跨平台Http任务
 *
 * @author xuxueli 2018-09-16 03:48:34
 */
@JobHandler(value = "walletHandler")
@Component
@Slf4j
public class WalletJobHandler extends IJobHandler {

    @Autowired
    MyWaterBiz myWaterBiz;

    @Override
    public ReturnT<String> execute(String var1) {
        try {
             XxlJobLogger.log("-----定时器进入---walletHandler---");
            log.info("-----定时器进入---walletHandler---");
            myWaterBiz.updTodayAmount();
            ReturnT returnT = new ReturnT();
            returnT.setCode(100);
            returnT.setMsg("成功");
            return returnT;
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
        }
    }

}