/**
 * Copyright (c) 2011-2014, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 */

package com.xxfc.platform.summit.model;

import java.io.Serializable;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;




/**
 * 封装 access_token
 */
public class AccessToken implements Serializable {
	
	private static final long serialVersionUID = -822464425433824314L;
	
	private String access_token;	// 正确获取到 access_token 时有值
	private Integer expires_in;		// 正确获取到 access_token 时有值

	
	private Long expiredTime;		// 正确获取到 access_token 时有值，存放过期时间
	private String json;
	
	@SuppressWarnings("unchecked")
	public AccessToken(String jsonStr) {
		this.json = jsonStr;

		try {
			JSONObject temp =JSON.parseObject(jsonStr);
			

			access_token =   temp.getString("access_token");
			expires_in = temp.getInteger("expires_in");


			if (expires_in != null){
				expiredTime = System.currentTimeMillis() + ((expires_in -5) * 1000);
				System.out.println("----expiredTime==="+expiredTime);
			}


		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public AccessToken(String json,String access_token,Integer expires_in,Long expiredTime) {
		this.json = json;
		this.access_token =  access_token;
		this.expires_in = expires_in;
		this.expiredTime=expiredTime;
	}

	public String getJson() {
		return json;
	}
	
	public boolean isAvailable() {
		if (expiredTime < System.currentTimeMillis())
			return false;
		return access_token != null;
	}

	public void setAccess_token(String access_token) {
		this.access_token = access_token;
	}

	public void setExpires_in(Integer expires_in) {
		this.expires_in = expires_in;
	}

	public void setExpiredTime(Long expiredTime) {
		this.expiredTime = expiredTime;
	}


	public void setJson(String json) {
		this.json = json;
	}

	private Integer getInt(Map<String, Object> temp, String key) {
		Number number = (Number) temp.get(key);
		return number == null ? null : number.intValue();
	}

	public String getAccessToken() {
		return access_token;
	}

	public Integer getExpiresIn() {
		return expires_in;
	}

	public Long getExpiredTime() {
		return expiredTime;
	}
	
	
}
