package com.github.wxiaoqi.security.admin.handler;

import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.util.Map;

import static com.github.wxiaoqi.security.admin.config.RabbitAdminConfig.MEMBER_CHANGE_QUEUE;

/**
 * @ClassName : MemberChangeMQHandler
 * @Description : 修改会员等级
 * @Author : jiaoruizhen
 * @Date: 2020-11-07 11:10
 */
@Component
@Slf4j
public class MemberChangeMQHandler {

	@Autowired
	BaseUserMemberBiz baseUserMemberBiz;

	@RabbitListener(queues = MEMBER_CHANGE_QUEUE)
	public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
		try {
			Thread.sleep(2000);
			String msg = new String(message.getBody(), "UTF-8");
			log.info("接收到的消息-----msg===="+msg);
			BaseUserMember baseUserMember = JSONUtil.toBean(msg, BaseUserMember.class);
			baseUserMemberBiz.executeParentMemberLevel(baseUserMember);
		} catch (Exception e) {
			log.error("接收消息失败：{}", e);
		}

	}
}
