package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 会员分成记录
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-03 11:12:15
 */
@Data
@Table(name = "member_share_record")
public class MemberShareRecord implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  会员分成记录id
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("会员分成记录id")
    private Long id;
	
	    /**
     *  订单编号
     */
    @Column(name = "order_no")
	@ApiModelProperty(value = "订单编号")
    private String orderNo;
	
	    /**
     *  参与会员用户id，用逗号分隔
     */
    @Column(name = "member_ids")
	@ApiModelProperty(value = "参与会员用户id，用逗号分隔")
    private String memberIds;
	
	    /**
     *  会员订单支付时间
     */
    @Column(name = "pay_time")
	@ApiModelProperty(value = "会员订单支付时间")
    private Long payTime;
	
	    /**
     *  会员等级
     */
    @Column(name = "member_level")
	@ApiModelProperty(value = "会员等级")
    private Integer memberLevel;
	
	    /**
     *  会员等级id
     */
    @Column(name = "member_level_id")
	@ApiModelProperty(value = "会员等级id")
    private Integer memberLevelId;
	
	    /**
     *  订单金额
     */
    @Column(name = "order_amount")
	@ApiModelProperty(value = "订单金额")
    private BigDecimal orderAmount;
	
	    /**
     *  总分成金额
     */
    @Column(name = "total_amount")
	@ApiModelProperty(value = "总分成金额")
    private BigDecimal totalAmount;
	
	    /**
     *  每人可分成金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "每人可分成金额")
    private BigDecimal amount;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long updTime;
	
	    /**
     *  订单下单用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "订单下单用户id")
    private Long userId;
	
	    /**
     *  下单时间
     */
    @Column(name = "order_time")
	@ApiModelProperty(value = "下单时间")
    private Long orderTime;
	
	    /**
     *  分成人数
     */
    @Column(name = "member_num")
	@ApiModelProperty(value = "分成人数")
    private Integer memberNum;
	

}
