package com.xxfc.platform.vehicle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

@Table(name = "vehicle_count_record")
@Data
public class VehicleCountRecord {
    @Id
    private Integer id;

    private Integer type;

    /**
     * 应出车数量
     */
    @Column(name = "departure_num")
    private Integer departureNum;

    /**
     * 实际出车数量
     */
    @Column(name = "actual_departure_num")
    private Integer actualDepartureNum;

    /**
     * 延期交车数量
     */
    @Column(name = "after_departure_num")
    private Integer afterDepartureNum;

    /**
     * 提前交车数
     */
    @Column(name = "before_departure_num")
    private Integer beforeDepartureNum;

    /**
     * 应还车数量
     */
    @Column(name = "arrival_num")
    private Integer arrivalNum;

    /**
     * 未提前还车数量
     */
    @Column(name = "actual_arrival_num")
    private Integer actualArrivalNum;

    /**
     * 延后还车数量
     */
    @Column(name = "after_arrival_num")
    private Integer afterArrivalNum;

    /**
     * 提前还车数量
     */
    @Column(name = "before_arrival_num")
    private Integer beforeArrivalNum;

    /**
     * 统计日期 yyyy-MM-dd
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(
            pattern = "yyyy-MM-dd"
    )
    private Date countDate;

    @Transient
    private String startTime;

    @Transient
    private String endTime;

}