package com.github.wxiaoqi.security.admin.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/18 10:50
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WalletDetailAdminVo {
    private Integer id;

    private String username;

    private String phone;

    @ApiModelProperty(value = "来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买")
    private Integer source;

    @ApiModelProperty("佣金商品名称")
    private String title;

    @ApiModelProperty("商品价格")
    private BigDecimal price;

    @ApiModelProperty("提成比例")
    private Integer extract;

    @ApiModelProperty("入帐状态")
    private Integer waiting;

    @ApiModelProperty(value = "收入/支出的金额(分)")
    private BigDecimal amount;

    @ApiModelProperty(value = "0收入 1支出")
    private Integer itype;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty(value = "单号")
    private Integer cono;

    @ApiModelProperty(value = "提现单号")
    private String withDrawOrderNo;

    @ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;

    private String sourceName;

}
