package com.xxfc.platform.universal.service;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.universal.biz.LicensePlateTypeBiz;
import com.xxfc.platform.universal.biz.SearchableCityBiz;
import com.xxfc.platform.universal.entity.LicensePlateType;
import com.xxfc.platform.universal.utils.CertifHttpUtils;
import com.xxfc.platform.universal.vo.TrafficViolations;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 违章查询
 * 注意:调用"北京库斯曼科技有限公司"的接口,返回参是Unicode编码
 */
@Service
public class TrafficViolationsService {

    @Autowired
    private LicensePlateTypeBiz licensePlateTypeBiz;

    @Value("${ALIYUN.CODE}")
    private String CODE;
    @Value("${RETURN.TYPE}")
    private String TYPE;

    private static final String CITY_HOST = "https://weizhang.market.alicloudapi.com";
    private static final String CITY_PATH = "/wz/province";
    private static final String CITY_METHOD = "GET";

    private static final String VIOLATIONS_HOST = "https://weizhang.market.alicloudapi.com";
    private static final String VIOLATIONS_PATH = "/wz/query";
    private static final String VIOLATIONS_METHOD = "GET";

    private static final String GET_LICENSE_PLATE_TYPE_HOST = "https://weizhang.market.alicloudapi.com";
    private static final String GET_LICENSE_PLATE_TYPE_PATH = "/wz/type";
    private static final String GET_LICENSE_PLATE_TYPE_METHOD = "GET";

    private static final String TYPE_NAME = "type";
    private static final String PLATENO_NAME="plateno";
    private static final String ENGINENO_NAME="engineno";
    private static final String FRAMENO_NAME="frameno";
    private static final String AUTHORIZATION="Authorization";


    /**
     * 支持查询的城市
     * @return
     * @throws Exception
     */
//  @Scheduled(cron = "0 0　0 * * ?")
    public String getCity() throws Exception {
        Map<String, String> headers = new HashMap<
                String, String>();
        headers.put(AUTHORIZATION, "APPCODE " + CODE);
        Map<String, String> querys = new HashMap<String, String>();
        querys.put(TYPE_NAME, TYPE);
        HttpResponse httpResponse = CertifHttpUtils.doGet(CITY_HOST, CITY_PATH, CITY_METHOD, headers, querys);
        HttpEntity entity = httpResponse.getEntity();
//        String result = EntityUtils.toString(entity);
//      ArrayList<SearchableCity> searchableCities = JSONObject.parseObject(result, ArrayList.class);
//      searchableCities.forEach(searchableCity ->searchableCity.setCreateDate(new Date()) );
//      searchableCityBiz.insertSearchableCities(searchableCities);
      return unicodeToString(EntityUtils.toString(entity));
    }


    /**s
     * 违章车辆查询
     * @param trafficViolations
     * @return
     */
    public String queryViolations(TrafficViolations trafficViolations) throws Exception {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION, "APPCODE " + CODE);
        Map<String, String> querys = new HashMap<String, String>();
        querys.put(TYPE_NAME, trafficViolations.getType());
        querys.put(PLATENO_NAME, trafficViolations.getPlateno());
        querys.put(ENGINENO_NAME, trafficViolations.getEngineno());
        querys.put(FRAMENO_NAME, trafficViolations.getFrameno());
        HttpResponse httpResponse = CertifHttpUtils.doGet(VIOLATIONS_HOST, VIOLATIONS_PATH, VIOLATIONS_METHOD, headers, querys);
        HttpEntity entity = httpResponse.getEntity();
        return unicodeToString(EntityUtils.toString(entity));
    }

    /**
     * 放入bean中
     * @throws Exception
     */
    public void saveLicensePlateType() throws Exception {
        String result = searchaLicensePlateType();
        if (StringUtils.isBlank(result)) {
            throw new BaseException("错误! 查询不到车辆类型");
        }
        Map<String,Object> resultMap = JSONObject.parseObject(result, Map.class);
        Integer status = (Integer) resultMap.get("status");
        Map<String,String> licensePlateTypeMap = (Map<String, String>) resultMap.get("result");
        if (status!=200||licensePlateTypeMap==null) {
            throw new BaseException("错误! 查询不到车辆类型");
        }
        ArrayList<LicensePlateType> licensePlateTypes=new ArrayList<>();
        for (Map.Entry<String, String> licensePlateTypeEntry : licensePlateTypeMap.entrySet()) {
                 licensePlateTypes.add(new LicensePlateType(licensePlateTypeEntry.getKey(),licensePlateTypeEntry.getValue()));
        }
        licensePlateTypeBiz.insertLicensePlateType(licensePlateTypes);
    }


    /**
     * Unicode转汉字字符串
     * @param str
     * @return
     */

    private String unicodeToString(String str) {

        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        char ch;
        while (matcher.find()) {

            String group = matcher.group(2);

            ch = (char) Integer.parseInt(group, 16);

            String group1 = matcher.group(1);
            str = str.replace(group1, ch + "");
        }
        return str;

    }


    /**
     * 调用接口获取车辆车型和代码
     * @return
     * @throws Exception
     */
    public String searchaLicensePlateType() throws Exception {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION, "APPCODE " + CODE);
        HashMap<String, String> querys = new HashMap<>();

        HttpResponse httpResponse = CertifHttpUtils.doGet(GET_LICENSE_PLATE_TYPE_HOST,
                GET_LICENSE_PLATE_TYPE_PATH,
                GET_LICENSE_PLATE_TYPE_METHOD,
                headers,
                querys
        );
        HttpEntity entity = httpResponse.getEntity();
        return unicodeToString(EntityUtils.toString(entity));
    }

    public ArrayList<LicensePlateType> getLicensePlateType() {
        List<LicensePlateType> licensePlateTypes = licensePlateTypeBiz.selectListAll();
        if (CollectionUtils.isEmpty(licensePlateTypes)) {

        }
        return null;
    }
}
