package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户会员
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 19:38:56
 */
@Data
public class UserMemberDTO  {

	public static final int ISBIND_BIND = 1;
	
	/**
     *  用户id
     */
	@ApiModelProperty(value = "用户id")
    private Integer userId;

	
	/**
     *  会员等级
     */
	@ApiModelProperty(value = "会员等级")
    private Integer memberLevel;

	
	/**
     *  0:未支付 1：绑定 2:解绑
     */
	@ApiModelProperty(value = "0:未支付 1：绑定 2:解绑")
    private Integer isBind;
	
	/**
     *  赠送总天数
     */
	@ApiModelProperty(value = "赠送总天数")
    private Integer totalNumber;
	
	/**
     *  剩余天数
     */
	@ApiModelProperty(value = "剩余天数")
    private Integer rentFreeDays;


	//折扣
	@ApiModelProperty(value = "折扣")
	private Integer discount;


	

}
