package com.xxfc.platform.vehicle.entity;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Table(name = "vehicle_upkeep_log")
public class VehicleUpkeepLog {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    private Integer id;

    /**
     * 车辆ID
     */
    @Column(name = "vehicle_id")
    private String vehicleId;

    /**
     * 保养人
     */
    private String operator;

    /**
     * 保养日期
     */
    private Date date;

    /**
     * 公里数
     */
    private Integer mileage;

    /**
     * 花费
     */
    private BigDecimal amount;

    /**
     * 审批人
     */
    private String approvers;

    /**
     * 分公司ID
     */
    @Column(name = "branch_company_id")
    private Integer branchCompanyId;

    @Column(name = "create_time")
    private Date createTime;

    /**
     * @return id
     */
    public Integer getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取车辆ID
     *
     * @return vehicle_id - 车辆ID
     */
    public String getVehicleId() {
        return vehicleId;
    }

    /**
     * 设置车辆ID
     *
     * @param vehicleId 车辆ID
     */
    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    /**
     * 获取保养人
     *
     * @return operator - 保养人
     */
    public String getOperator() {
        return operator;
    }

    /**
     * 设置保养人
     *
     * @param operator 保养人
     */
    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * 获取保养日期
     *
     * @return date - 保养日期
     */
    public Date getDate() {
        return date;
    }

    /**
     * 设置保养日期
     *
     * @param date 保养日期
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * 获取公里数
     *
     * @return mileage - 公里数
     */
    public Integer getMileage() {
        return mileage;
    }

    /**
     * 设置公里数
     *
     * @param mileage 公里数
     */
    public void setMileage(Integer mileage) {
        this.mileage = mileage;
    }

    /**
     * 获取花费
     *
     * @return amount - 花费
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * 设置花费
     *
     * @param amount 花费
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * 获取审批人
     *
     * @return approvers - 审批人
     */
    public String getApprovers() {
        return approvers;
    }

    /**
     * 设置审批人
     *
     * @param approvers 审批人
     */
    public void setApprovers(String approvers) {
        this.approvers = approvers;
    }

    /**
     * 获取分公司ID
     *
     * @return branch_company_id - 分公司ID
     */
    public Integer getBranchCompanyId() {
        return branchCompanyId;
    }

    /**
     * 设置分公司ID
     *
     * @param branchCompanyId 分公司ID
     */
    public void setBranchCompanyId(Integer branchCompanyId) {
        this.branchCompanyId = branchCompanyId;
    }

    /**
     * @return create_time
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * @param createTime
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}