package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 平台车型分类表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_cata")
public class VehicleCata implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键id
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    //车型id
    @Column(name = "vehicle_model_id")
	@ApiModelProperty(value = "车型id")
    private Integer vehicleModelId;
	
	    //分类id
    @Column(name = "cata_id")
	@ApiModelProperty(value = "分类id")
    private Integer cataId;
	
	    //删除状态 0：有效 1：删除
    @Column(name = "isdel")
	@ApiModelProperty(value = "删除状态 0：有效 1：删除")
    private Integer isdel;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	

}
