package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.xxfc.platform.im.biz.UserBiz;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("user")
public class UserController {

    @Autowired
    private UserBiz mtBiz;

    /**
     * 注册
     * @param map
     * @return
     */
    @RequestMapping(value = "/app/unauth/register", method = RequestMethod.POST)
    @ResponseBody
    @IgnoreClientToken
    public BaseResponse register(@RequestBody Map<String, Object> map) {
        return mtBiz.register(map);
    }

    /**
     * 登录
     * @param map
     * @return
     */
    @RequestMapping(value = "/app/unauth/login", method = RequestMethod.POST)
    @ResponseBody
    @IgnoreClientToken
    public BaseResponse login(@RequestBody Map<String, Object> map) {
        BaseResponse baseResponse = new BaseResponse();
        String result = mtBiz.login(map);
        baseResponse.setStatus(200);
        baseResponse.setMessage(result);
        return baseResponse;
    }
}
