package com.xxfc.platform.im.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

import java.io.*;
import java.net.*;

/**
 * 根据IP地址获取详细的地域信息 淘宝API :
 * http://ip.taobao.com/service/getIpInfo.php?ip=218.192.3.42 新浪API :
 * http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=218.192.3.42
 * 
 * @File AddressUtils.java
 * @Package org.gditc.weicommunity.util
 * @Description TODO
 * @Copyright Copyright © 2014
 * @Site https://github.com/Cryhelyxx
 * @Blog http://blog.csdn.net/Cryhelyxx
 * @Email cryhelyxx@gmail.com
 * @Company GDITC
 * @Date 2014年11月6日 下午1:46:37
 * @author Cryhelyxx
 * @version 1.0
 */
@Slf4j
public class AddressUtils {
	/**
	 * 
	 * @param content
	 *            请求的参数 格式为：name=xxx&pwd=xxx
	 * @param encoding
	 *            服务器端请求编码。如GBK,UTF-8等
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	private static final String APPKEY = "1DXbTfk6mChS5yvO9GxVnIDZzH5p9FKE"; 
	public static String getAddresses(String ip) throws UnsupportedEncodingException {
		// 这里调用淘宝API
		String urlStr = "http://ip.taobao.com/service/getIpInfo.php";
		// 从http://whois.pconline.com.cn取得IP所在的省市区信息
		if (!ip.contains(":")) {

			String returnStr = getResult(urlStr, "ip=" + ip, "utf-8");
			if (!StringUtils.isEmpty(returnStr)) {
				// 处理返回的省市区信息
				System.out.println(returnStr);
				JSONObject jsonObject = JSONObject.parseObject(returnStr);
				returnStr = JSONObject.parseObject(jsonObject.getString("data")).getString("country") + " "
						+ JSONObject.parseObject(jsonObject.getString("data")).getString("region") + " "
						+ JSONObject.parseObject(jsonObject.getString("data")).getString("city") + " "
						+ JSONObject.parseObject(jsonObject.getString("data")).getString("isp");
				return returnStr;
			}
		}
		return null;
	}

	/**
	 * @param urlStr
	 *            请求的地址
	 * @param content
	 *            请求的参数 格式为：name=xxx&pwd=xxx
	 * @param encoding
	 *            服务器端请求编码。如GBK,UTF-8等
	 * @return
	 */
	private static String getResult(String urlStr, String content, String encoding) {
		URL url = null;
		HttpURLConnection connection = null;
		try {
			url = new URL(urlStr);
			connection = (HttpURLConnection) url.openConnection();// 新建连接实例
			connection.setConnectTimeout(2000);// 设置连接超时时间，单位毫秒
			connection.setReadTimeout(2000);// 设置读取数据超时时间，单位毫秒
			connection.setDoOutput(true);// 是否打开输出流 true|false
			connection.setDoInput(true);// 是否打开输入流true|false
			connection.setRequestMethod("POST");// 提交方法POST|GET
			connection.setUseCaches(false);// 是否缓存true|false
			connection.connect();// 打开连接端口
			DataOutputStream out = new DataOutputStream(connection.getOutputStream());// 打开输出流往对端服务器写数据
			out.writeBytes(content);// 写数据,也就是提交你的表单 name=xxx&pwd=xxx
			out.flush();// 刷新
			out.close();// 关闭输出流
			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));// 往对端写完数据对端服务器返回数据
			// ,以BufferedReader流来读取
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (connection != null) {
				connection.disconnect();// 关闭连接
			}
		}
		return null;
	}

	/**
	 * unicode 转换成 中文
	 * 
	 * @author fanhui 2007-3-15
	 * @param theString
	 * @return
	 */
	public static String decodeUnicode(String theString) {
		char aChar;
		int len = theString.length();
		StringBuffer outBuffer = new StringBuffer(len);
		for (int x = 0; x < len;) {
			aChar = theString.charAt(x++);
			if (aChar == '\\') {
				aChar = theString.charAt(x++);
				if (aChar == 'u') {
					int value = 0;
					for (int i = 0; i < 4; i++) {
						aChar = theString.charAt(x++);
						switch (aChar) {
						case '0':
						case '1':
						case '2':
						case '3':
						case '4':
						case '5':
						case '6':
						case '7':
						case '8':
						case '9':
							value = (value << 4) + aChar - '0';
							break;
						case 'a':
						case 'b':
						case 'c':
						case 'd':
						case 'e':
						case 'f':
							value = (value << 4) + 10 + aChar - 'a';
							break;
						case 'A':
						case 'B':
						case 'C':
						case 'D':
						case 'E':
						case 'F':
							value = (value << 4) + 10 + aChar - 'A';
							break;
						default:
							throw new IllegalArgumentException("Malformed      encoding.");
						}
					}
					outBuffer.append((char) value);
				} else {
					if (aChar == 't') {
						aChar = '\t';
					} else if (aChar == 'r') {
						aChar = '\r';
					} else if (aChar == 'n') {
						aChar = '\n';
					} else if (aChar == 'f') {
						aChar = '\f';
					}
					outBuffer.append(aChar);
				}
			} else {
				outBuffer.append(aChar);
			}
		}
		return outBuffer.toString();
	}
	 /** 
	    * @param addr 
	    * 查询的地址 
	    * @return 
	    * @throws IOException 
	    */
	    public Object[] getCoordinate(String addr) throws IOException { 
	        String lng = null;//经度
	        String lat = null;//纬度
	        String address = null; 
	        try { 
	            address = URLEncoder.encode(addr, "UTF-8");
	        }catch (UnsupportedEncodingException e1) { 
	            e1.printStackTrace(); 
	        } 
	      
	        String url = String .format("http://api.map.baidu.com/geocoder?address=%s&output=json&key=%s", address, APPKEY); 
	        URL myURL = null; 
	        URLConnection httpsConn = null; 
	        try { 
	            myURL = new URL(url); 
	        } catch (MalformedURLException e) { 
	            e.printStackTrace(); 
	        } 
	        InputStreamReader insr = null;
	        BufferedReader br = null;
	        try { 
	            httpsConn = (URLConnection) myURL.openConnection();// 不使用代理 
	            if (httpsConn != null) { 
	                insr = new InputStreamReader( httpsConn.getInputStream(), "UTF-8"); 
	                br = new BufferedReader(insr); 
	                String data = null; 
	                int count = 1;
	                while((data= br.readLine())!=null){ 
	                    if(count==5){
	                        lng = (String)data.subSequence(data.indexOf(":")+1, data.indexOf(","));//经度
	                        count++;
	                    }else if(count==6){
	                        lat = data.substring(data.indexOf(":")+1);//纬度
	                        count++;
	                    }else{
	                        count++;
	                    }
	                } 
	            } 
	        } catch (IOException e) { 
	            e.printStackTrace(); 
	        } finally {
	            if(insr!=null){
	                insr.close();
	            }
	            if(br!=null){
	                br.close();
	            }
	        }
	        return new Object[]{lng,lat}; 
	    } 
	    public static String getLocationByBaiduMap(String longitude,String latitude) throws Exception {
	        String addrJson = geturl("http://api.map.baidu.com/geocoder/v2/?ak=" + APPKEY + "&location=" + latitude + "," + longitude + "&output=json&pois=1");
	        System.out.println(addrJson);
	        JSONObject jobjectaddr =  JSON.parseObject(addrJson);
	        //JSONObject rJsonObject=jobjectaddr.getJSONObject("result");
	        //System.out.println(rJsonObject);
	        String addr=jobjectaddr.getJSONObject("result").getString("formatted_address");
	        //addr=(String) JSON.parseObject(addr).get("city");
	        //addr=new String(addr.getBytes("gbk"),"UTF-8");
	        return addr;
	    }
	    private static String geturl(String geturl) throws Exception {
	        //请求的webservice的url
	        URL url = new URL(geturl);
	        //创建http链接
	        HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();

	        //设置请求的方法类型
	        httpURLConnection.setRequestMethod("POST");

	        //设置请求的内容类型
	        httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");

	        //设置发送数据
	        httpURLConnection.setDoOutput(true);
	        //设置接受数据
	        httpURLConnection.setDoInput(true);

	        //发送数据,使用输出流
	        OutputStream outputStream = httpURLConnection.getOutputStream();
	        //发送的soap协议的数据
	    //    String requestXmlString = requestXml("北京");

	        String content = "user_id="+ URLEncoder.encode("13846", "utf-8");

	        //发送数据
	        outputStream.write(content.getBytes());

	        //接收数据
	        InputStream inputStream = httpURLConnection.getInputStream();
	        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));  
	        StringBuffer buffer = new StringBuffer();  
	        String line = "";  
	        while ((line = in.readLine()) != null){  
	          buffer.append(line);  
	        }  
	       String str = buffer.toString();  

	        return str;
	    }
	public static String  getMapaddress(String lats,String lngs){
		try{
			//  AK 百度开放平台申请的KEY
			URL url = new URL("http://api.map.baidu.com/geocoder/v2/?ak=wPPxsfCtNFm4PqEV68jbDdjP7U4twstj&callback=renderReverse&location="+ lats + "," + lngs + "&output=json&pois=1");
			HttpURLConnection ucon = (HttpURLConnection) url.openConnection();
			ucon.connect();

			InputStream in = ucon.getInputStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(in,"UTF-8"));
			String str = reader.readLine();

			str = str.substring(str.indexOf("(") + 1, str.length()-1);
			log.info("解析的地址，str = {}", str);
			JSONObject jsonObject =  JSONObject.parseObject(str);
			String address = "";
			address = jsonObject.getJSONObject("result").getString("formatted_address");
			in.close();
			reader.close();
			return address;
	            /*outprint.print(address);
	            outprint.close();
	            outprint=null;  */
		}catch(Exception e){
			e.printStackTrace();
		}
		return "";
	}


	// 测试
	public static void main(String[] args) {
		// 测试ip 219.136.134.157 中国=华南=广东省=广州市=越秀区=电信
		String ip = "219.136.134.157";
		String address = "";
		try {
			address = getMapaddress("37.2365037325","97.9164620226");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println(address);
		// 输出结果为：广东省,广州市,越秀区
	}
}