package com.xxfc.platform.campsite.mapper;

import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminFindDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminPageDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopDetailDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopPageDTO;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 营地店铺表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteShopMapper extends Mapper<CampsiteShop> {


    /**
     * 根据店铺类型查找店铺列表
     * @param typeId
     */
    List<CampsiteShopPageDTO> findAllCampsiteShopsByType(@Param("typeId") Integer typeId);

    /**
     * 首页营地列表
     * @param start
     * @param size
     * @return
     */
    List<GoodDataVO> findAllByHome(@Param("start") Integer start, @Param("size") Integer size);

    /**
     * 根据店铺id查询
     * @param id
     * @return
     */
    CampsiteShopDetailDTO findCampsiteShopDetailById(Integer id);

    /**
     * 根据条件查询
     * @param campsiteShopAdminFindDTO
     * @return
     */
    List<CampsiteShopAdminPageDTO> findAllCampsiteShops(CampsiteShopAdminFindDTO campsiteShopAdminFindDTO);

    /**
     * 更新店铺的状态
     * @param id
     * @param status
     * @return
     */
    int updateCampsiteStatusById(@Param("id") int id,@Param("status") int status);

    /**
     * 更新店铺的上下架状态
     * @param id
     * @param status
     * @return
     */
    int updateCampsiteSaleStatusById(@Param("id") Integer id, @Param("status") Integer status);

    /**
     * 检验营地名称
     * @param id
     * @param name
     * @return
     */
    int checkNameExist(@Param("id") Integer id,@Param("name") String name);
}
